document.addEventListener("DOMContentLoaded", function () {
  new DataTable('#myTable', {
    language: {
      lengthMenu: "Tampilkan _MENU_ baris",
      zeroRecords: "Tidak ada data yang cocok",
      info: "Menampilkan _START_ sampai _END_ dari _TOTAL_ data",
      infoEmpty: "Data tidak tersedia",
      infoFiltered: "(disaring dari _MAX_ total data)",
      search: "Pencarian:",
      paginate: {
        previous: "Sebelumnya",
        next: "Selanjutnya"
      }
    },
    layout: {
      topStart: {
        pageLength: {
          menu: [10, 25, 50, 100]
        }
      },
      topEnd: {
        search: {
          placeholder: 'Ketik untuk mencari...'
        }
      },
      bottomEnd: {
        paging: {
          buttons: 3
        }
      }
    },
    columnDefs: [
      { targets: -1, orderable: false, searchable: false } // Kolom terakhir (Aksi)
    ],
    pagingType: "simple_numbers"
  });
});
