iziToast.settings({
  timeout: 3000,
  resetOnHover: true,
  transitionIn: 'flipInX',
  transitionOut: 'flipOutX',
  position: 'topRight',
  onOpen: function () { console.log('toast dibuka'); },
  onClose: function () { console.log('toast ditutup'); }
});

$('#infoClick').click(function () {
  iziToast.info({position: "center", title: 'Hello', message: 'iziToast.info()'});
});

$('#successClick').click(function () {
  iziToast.success({timeout: 5000, icon: 'fa fa-chrome', title: 'OK', message: 'iziToast.success() with custom icon!'});
});

$('#warningClick').click(function () {
  iziToast.warning({position: "bottomLeft", title: 'Caution', message: '日本語環境のテスト'});
});

$('#errorClick').click(function () {
  iziToast.error({title: 'Error', message: 'Illegal operation'});
});

$('#customClick').click(function () {
  iziToast.show({
    color: 'dark',
    icon: 'fa fa-user',
    title: 'Hey',
    message: 'Custom Toast!',
    position: 'center',
    progressBarColor: 'rgb(0, 255, 184)',
    buttons: [
      [
        '<button>Ok</button>',
        function (instance, toast) {
          alert("Hello world!");
        }
      ],
      [
        '<button>Close</button>',
        function (instance, toast) {
          instance.hide({ transitionOut: 'fadeOutUp' }, toast);
        }
      ]
    ]
  });
});